jQuery(function($){
	
	$("#seccionDatosSolicitante_legend").on("click",function(){$("#seccionDatosSolicitante").toggle();});
	$("#seccionRepresentanteLegal_legend").on("click",function(){$("#seccionRepresentanteLegal").toggle();});
	$("#seccionEmpresa_legend").on("click",function(){$("#seccionEmpresa").toggle();});
	$("#seccionEstadoTramitacion_legend").on("click",function(){$("#seccionEstadoTramitacion").toggle();});	

	cargarCombos();
	
	$("#expedientesRERA").rup_table({
		
		url: "../ab03b24v00",
		colNames: [
			$.rup.i18n.app.expedientes.expediente,
			$.rup.i18n.app.expedientes.fecReg,
			$.rup.i18n.app.expedientes.numRera,
			$.rup.i18n.app.expedientes.nif,
			$.rup.i18n.app.expedientes.razonSocial,
			$.rup.i18n.app.expedientes.municipio,
			$.rup.i18n.app.expedientes.provincia,			
			$.rup.i18n.app.expedientes.fase,
			$.rup.i18n.app.expedientes.tramite
		    
		],
		colModel: [
			{ 	name: "idExpediente", 
				label: "idExpediente",
			 	index: "id_Expediente",
				align: "right", 
				width: 110, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fecReg024Str", 
			 	label: "fecReg024Str",
				align: "left", 
				width: 90, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				report: true,
				resizable: true, 
				sortable: true
			},
			{ 	name: "numRera047", 
			 	label: "numRera047",
			 	index: "num_Rera_047",
				align: "left", 
				width: 70, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nifEmpresa047", 
			 	label: "nifEmpresa047",
			 	index: "nif_Empresa_047",
				align: "right", 
				width: 75, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nombreEmpresa047", 
			 	label: "nombreEmpresa047",
			 	index: "nombre_Empresa_047",
				align: "left", 
				width: 150, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "municipio047", 
			 	label: "municipio047",
			 	index: "municipio_047",
				align: "left", 
				width: 100, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "provincia047", 
			 	label: "provincia047",
			 	index: "provincia_047",
				align: "left", 
				width: 90, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fase" + $.rup_utils.capitalizedLang(), 
				label: "fase" + $.rup_utils.capitalizedLang(), 
			 	index: "fase_" + $.rup_utils.capitalizedLang(), 
				align: "left", 
				width: 200, 
				ruptype: "combo", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "tramite" + $.rup_utils.capitalizedLang(), 
				label: "tramite" + $.rup_utils.capitalizedLang(), 
			 	index: "tramite_" + $.rup_utils.capitalizedLang(),
				align: "left", 
				width: 200, 
				ruptype: "combo", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
			
        ],

        model:"Ab03b24v00",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"report"
         	],
		primaryKey: "idExpediente",
		sortname: "id_Expediente",
		sortorder: "asc",
		loadOnStartUp: false,
		feedback:{
			config:{
				block: false
			}
		},
		toolbar: {
			createDefaultToolButtons: false,
			buttons: []
		},
        report: {
        	buttons: [
              	{ 
              	'id': 'reports', 
              	'i18nCaption': $.rup.i18n.app.botones.informes, 
              	right: true,
        	    'buttons': [
        	        { 'i18nCaption': 'XLS', 'css': 'xls', 'url': '../ab03b24v00/xlsReport?ultimoTramite='+$("#ultimoTramite").val() },
        	        { 'i18nCaption': 'XLSX', 'css': 'xls', 'url': '../ab03b24v00/xlsxReport?ultimoTramite='+$("#ultimoTramite").val() },
        	        { 'i18nCaption': 'PDF', 'css': 'pdf', 'url': '../ab03b24v00/pdfReport?ultimoTramite='+$("#ultimoTramite").val() }
        	    ]
              	}
        	]
        }
	});
	
	$("#expedientesRERA").on("rupTable_beforeEditRow", 
		function(deleteOptions, selectedRow){
			if ($("#expedientesRERA_filter_form").validate().checkForm()) {
	
				fila = $("#expedientesRERA").rup_grid('getGridParam', 'selrow');
				obj = $("#expedientesRERA").rup_grid('getRowData', fila);
	
				window.location.href = $.rup.CTX_PATH + "ab03b24v00/irDetalle/"+obj.idExpediente;
	
				return false;
			} else {
				return false;
			}
		});	
	
	$("#expedientesRERA_filter_form").rup_validate({
		feedback:$("#expedientesRERA_feedback"),
		liveCheckingErrors: false,
		rules:{
			"idProv024":{digits:true},
			"id024":{digits:true},
			"idAno024":{digits:true},
			"fecRegDesde":{date:true, validacionFechas:true},
			"fecRegHasta":{date:true, validacionFechas:true},
			"cp047":{digits:true}
		}
	});	
		
	$("#expedientesRERA").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#expedientesRERA_filter_form"))){	
				return true;
			} else {
				return false;
			}
		});

	$("#ultimoTramite").on("click", function(){
		if ($("#ultimoTramite").is(":checked")){
			$("#ultimoTramite").val('S');
			$("#filterEstado").show();
		} else {
			$("#ultimoTramite").val('N');
			$("#filterEstado").hide();
			$("#id035Estado").rup_combo("select","");
		}
	});
});


function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};

function cargarCombos(){
	
cargarComboProvincia($('#provincia047'), "comboProvinciaTodas");

	$('#municipio047').rup_combo({
		source : "/ab03bRERAWar/ab03bNora/comboMunicipio",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:"",
		parent:["provincia047"],
		change:function(){
			$("#calle047_label").data("tmp.loadObjects.term",null);
			//validamos que la calle existe
			if($("#calle047").val()!=''){
				var accion="validarCalleCorrectaString/";
				if($.isNumeric($("#calle047").val())){
					accion="validarCalleCorrectaId/";
				}
				$.ajax({
					type : "GET",
					url : "/ab03bRERAWar/ab03bNora/"+accion,
					data:{
			    		'muni':$("#municipio047").val(),
			    		'prov':$("#provincia047").val(),
			    		'desc':$("#calle047").val()
			    		},
					dataType : "json",
					error : function(jqXHR, textStatus, errorThrown) {
						calleCorrecta= false;
					},
					success : function(data, textStatus, jqXHR) {
						
						if(data==0){
							calleCorrecta= false;
						}
						else{
							calleCorrecta= true;	
						}
					}
				});
			}else{
				calleCorrecta=true;
			}
		
		
			// Autocomplete calle
			var urlSource = "/ab03bRERAWar/ab03bNora/comboCalle?";
			$("#calle047").rup_autocomplete({
				source:urlSource+"prov="+$("#provincia047").val()+"&mun="+$("#municipio047").val(),
				sourceParam:{
					label:"ds_o",
					value:"id"
				},
				minLength: 1,
				combobox: false,
				select: function(){
					calleCorrecta=true;
				}
			});
		}
	});
	
	$('#id017Fase').rup_combo({
		source : "/ab03bRERAWar/ab03b17t00/comboFase",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:""
	});	
	
	
	$('#id018Tramite').rup_combo({
		source : "/ab03bRERAWar/ab03b18t00/comboTramite",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		parent:["id017Fase"],
		blank:""
	});
	
	$('#id035Estado').rup_combo({
		source : "/ab03bRERAWar/ab03b35t00/comboEstado",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 340,
		rowStriping:true,
		inputText:true,
		ordered:false,
		blank:""
	});
	
	$("#fecRegDesde").rup_date();
	$("#fecRegHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fecRegDesde").val();
		var fechaHasta=$("#fecRegHasta").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
		
	});	
}

function cargarComboProvincia(combo, accion){
	// provincia solicitante
	combo.rup_combo({
		source : "/ab03bRERAWar/ab03bNora/"+accion,
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		blank:""
	});
}

//Funcion limpiar
$('#expedientesRERA_filter_cleanLink').click(function(event){
	resetFiltro($("#expedientesRERA_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#expedientesRERA_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#expedientesRERA_feedback").rup_feedback("close");
	
	$("#expedientesRERA").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#expedientesRERA_filter_form")).remove();
});


